/************************************************************************
 * \file: trace_q.h
 *
 * \version: $Id: trace_q.h,v 1.19 2012/05/28 10:32:35 jayanth.mc Exp $
 *
 * This file implements circular queue for Trace.
 *
 * \component: Gen2 Trace
 *
 * \author B. Das         bhaskar.das(o)in.bosch.com
 *         Sakthivelu S.  sakthivelu.s(o)in.bosch.com
 *\Modified: Arun V
 * \copyright: (c) 2003 - 2009 ADIT
 *
 ***********************************************************************/
#ifndef _TRACE_Q_H_
#define _TRACE_Q_H_

#include "trace_impl.h"

#define GET_POINTER(q, offset) \
  (q->start + offset)

#define GET_OFFSET(q, ptr) \
  ((U32)(ptr - q->start))

#define RETRY_CNT 1000

/* Queue fill status */
typedef enum
{
  TRACE_Q_EMPTY         = 0x00,
  TRACE_Q_PKTS_PENDING  = 0x01,
  TRACE_Q_SKIP_PKT      = 0x02
}TRACE_q_status;

/* Queue block mode status */
typedef enum
{
  TRACE_NO_BLOCK_MODE = 0x01,
  TRACE_BLOCK_MODE    = 0x00
}TRACE_Q_BLOCK_STAT;

/* Queue packet available status */
typedef enum
{
  TRACE_PACKET_NOT_AVAILABLE = 0x00,
  TRACE_PACKET_AVAILABLE     = 0x01,
  TRACE_MIN_PKTS_IN_QUEUE    = 0x0a
}TRACE_Q_PKT_STATUS;

typedef U8 TRACE_q_fill_stat;



/* Queue manager - shared info */
typedef struct
{
  pthread_mutex_t    lock;         /* Task context lock                      */
  volatile U32       q_full;          /* Flag to indicate Queue is full      */
  volatile U32       wr;              /* Write pointer                       */
  volatile U32       rd;              /* Read pointer                        */
  U32                pkt_sz;          /* Per packet size                     */
  U32                dat_avl;         /* Event to indicate data available    */
  U32                wai_4_spc;       /* Event to indicate no space          */
  TRACE_Q_BLOCK_STAT blck_mode:32;    /* Blockmode status                    */
  U32                count;         /* Packet write count                  */
  U32                ovrwr_count;   /* Packet overwrite count              */
  U32                remain;        /* Remaining Packet count              */
  U32                ovrwr_cnt_alias;   /* Overwrite count for update      */
}TRACE_q_sh;

/* Queue manager */
typedef struct
{
  U8*                   buf;          /* *bufcarries the popped packet       */
  U8*                   start;        /* Queue start                         */
  U8*                   end;          /* Queue end                           */
  volatile U8*          wr_stat;      /* Queue write status                  */
  TRACE_q_sh*           sh;           /* Pointer to Trace Q shared info      */
  TRACE_flg*            event;        /* For storing flag attribute          */
} TRACE_q;



EXPORT ER TRACE_q_push(TRACE_q* q, VP appl_buf);


/**
 * Pop packet from queue.
 *
 * \param q Pointer to queue
 *
 * return \li TRACE_Q_PKTS_PENDING if more packets are to be read
 *        \li TRACE_Q_EMPTY        if no more packets exists in the queue
 *        \li                      else error returned by concrete implementation
 */
EXPORT TRACE_q_status TRACE_q_pop(TRACE_q* q);

/**
 * This function returns the %age fill status of circular queue.
 *
 * \param q Pointer to queue
 *
 * return Queue fill status in percentage
 */
EXPORT TRACE_q_fill_stat TRACE_q_fill_status(TRACE_q* q);

/*@dhd3kor<17.09.2012>: SWGIIX-3101(SWGIIX-3097)[b_E21_X_MC] Processor Watchdog Reset detected*/
/**
* This function releases all the waiting tasks in TRACE_q_push.
*
* \param q Pointer to queue
*
* return status of the set flag function
*/
EXPORT ER TRACE_q_release_wait_tasks(TRACE_q* q);

#endif
